define([
    'underscore',
    'Layout',
    'modules/appointments/appointments-radio',
    'modules/appointments/requested/requested-appointments-list-view',
], function(_, Layout, radio, AppointmentsListView) {
    'use strict';

    describe('Requested Appointments List View', function() {
        var view;
        var $view;
        var layout = new Layout();

        layout.render();

        // TODO: upgrade Jasmine, change to beforeAll
        beforeEach(function() {
            spyOn(AppointmentsListView.prototype, 'styleLastChild').and.callFake(_.noop);

            view = new AppointmentsListView();

            layout.showChildView('content', view);
            $view = view.$el;
        });

        it('has the list heading', function() {
            var $headers = $view.find('#requested-appointments-table-list .table-list-head div');
            expect($($headers[0]).text()).toEqual('Last Updated');
            expect($($headers[1]).text()).toEqual('Status');
            expect($($headers[2]).text()).toEqual('Location');
            expect($($headers[3]).text()).toEqual('Type of Care');
            expect($($headers[4]).text()).toEqual('Type');
        });

        it('has the childViewContainer', function() {
            expect($view.has(view.childViewContainer).length).toEqual(1);
        });
    });
});
